% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daemon.R
\name{daemon}
\alias{daemon}
\title{Daemon Instance}
\usage{
daemon(
  url,
  dispatcher = TRUE,
  ...,
  asyncdial = FALSE,
  autoexit = TRUE,
  cleanup = TRUE,
  output = FALSE,
  idletime = Inf,
  walltime = Inf,
  maxtasks = Inf,
  tlscert = NULL,
  rs = NULL
)
}
\arguments{
\item{url}{(character) host or dispatcher URL to dial into, e.g.
'tcp://hostname:5555' or 'tls+tcp://10.75.32.70:5555'.}

\item{dispatcher}{(logical) whether dialing into dispatcher or directly to
host.}

\item{...}{reserved for future use.}

\item{asyncdial}{(logical) whether to dial asynchronously. \code{FALSE} errors if
connection fails immediately. \code{TRUE} retries indefinitely (more resilient
but can mask connection issues).}

\item{autoexit}{(logical) whether to exit when the socket connection ends.
\code{TRUE} exits immediately, \code{NA} completes current task first, \code{FALSE}
persists indefinitely. See Persistence section.}

\item{cleanup}{(logical) whether to restore global environment, packages, and
options to initial state after each evaluation.}

\item{output}{(logical) whether to output stdout/stderr. For local daemons
via \code{\link[=daemons]{daemons()}} or \code{\link[=launch_local]{launch_local()}}, redirects output to host process.}

\item{idletime}{(integer) milliseconds to wait idle before exiting.}

\item{walltime}{(integer) milliseconds of real time before exiting (soft
limit).}

\item{maxtasks}{(integer) maximum tasks to execute before exiting.}

\item{tlscert}{(character) for secure TLS connections. Either a file path to
PEM-encoded certificate authority certificate chain (starting with the TLS
certificate and ending with the CA certificate), or a length-2 vector of
(certificate chain, empty string \code{""}).}

\item{rs}{(integer vector) initial \code{.Random.seed} value. Set automatically by
host process; do not supply manually.}
}
\value{
Invisibly, an integer exit code: 0L for normal termination, and a
positive value if a self-imposed limit was reached: 1L (idletime), 2L
(walltime), 3L (maxtasks).
}
\description{
Starts up an execution daemon to receive \code{\link[=mirai]{mirai()}} requests. Awaits data,
evaluates an expression in an environment containing the supplied data,
and returns the value to the host caller. Daemon settings may be controlled
by \code{\link[=daemons]{daemons()}} and this function should not need to be invoked directly,
unless deploying manually on remote resources.
}
\details{
Daemons dial into the host or dispatcher, which listens at \code{url}. This
allows network resources to be added or removed dynamically, with the host
or dispatcher automatically distributing tasks to all connected daemons.
}
\section{Persistence}{


The \code{autoexit} argument governs persistence settings for the daemon. The
default \code{TRUE} ensures that it exits as soon as its socket connection with
the host process drops. A 200ms grace period allows the daemon process to
exit normally, after which it will be forcefully terminated.

Supplying \code{NA} ensures that a daemon always exits cleanly after its socket
connection with the host drops. This means that it can temporarily outlive
this connection, but only to complete any task that is currently in progress.
This can be useful if the daemon is performing a side effect such as writing
files to disk, with the result not being required back in the host process.

Setting to \code{FALSE} allows the daemon to persist indefinitely even when there
is no longer a socket connection. This allows a host session to end and a new
session to connect at the URL where the daemon is dialed in. Daemons must be
terminated with \code{daemons(NULL)} in this case instead of \code{daemons(0)}. This
sends explicit exit signals to all connected daemons.
}

