% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_series.R
\name{add_xy}
\alias{add_xy}
\title{Add XY Data to Chart}
\usage{
add_xy(
  sp,
  current_data,
  group_name,
  color_mapping,
  size,
  alpha,
  facet,
  tooltip,
  type,
  second_axis,
  include_legend
)
}
\arguments{
\item{sp}{A SveltePlot htmlwidget object to which the data will be added.}

\item{current_data}{A list of data frames representing the XY data series.}

\item{group_name}{A character vector of group names corresponding to each data series.}

\item{color_mapping}{A named list mapping group names to colors.}

\item{size}{A numeric value specifying the size of the points or line thickness.}

\item{alpha}{A numeric value between 0 and 1 specifying the opacity of the series.}

\item{facet}{A list of facets, specifying how the data should be split across multiple panels.}

\item{tooltip}{A logical value indicating whether tooltips should be displayed on hover.}

\item{type}{A character string specifying the chart type ('line', 'points', etc.).}

\item{second_axis}{A logical value indicating if the series should be plotted on a secondary y-axis.}

\item{include_legend}{A logical value indicating whether to include the series in the chart legend.}
}
\description{
This function adds XY (scatter or line) data to a SveltePlot chart. It supports customization
of aesthetics such as color, size, opacity, and more. It is used to overlay data points, lines,
or other XY elements onto the chart.
}
\keyword{internal}
