% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_series.R
\name{sp_add_series}
\alias{sp_add_series}
\title{Add Series to a SveltePlot Chart}
\usage{
sp_add_series(
  sp,
  data,
  mapping,
  type,
  alpha = 1,
  size = 2,
  colors = NULL,
  tooltip = TRUE,
  include_legend = TRUE,
  second_axis = FALSE
)
}
\arguments{
\item{sp}{A SveltePlot htmlwidget object to which the series will be added. This is typically the output
from a previous call to \code{\link{sp}} or \code{\link{sp_add_series}}.}

\item{data}{A data frame containing the data to be added as a series to the chart.}

\item{mapping}{A list of aesthetic mappings created by \code{\link{spaes}}. Each call to \code{sp_add_series}
requires its own set of mappings to correctly display the data.}

\item{type}{A character string specifying the type of series to add. Valid options are \code{"points"} for
scatter plots, \code{"line"} for line charts, or \code{"bands"} for confidence intervals or other purposes.}

\item{alpha}{A numeric value between 0 and 1 specifying the opacity of the series. Default is 1 (fully opaque).}

\item{size}{A positive numeric value determining the size of the points or thickness of the line. Default is 2.}

\item{colors}{A character vector of colors to use for the series. If \code{NULL} (the default), a default
color scheme is applied.}

\item{tooltip}{A logical value indicating whether tooltips should be shown on hover. Default is \code{TRUE}.}

\item{include_legend}{A logical value indicating whether a legend entry should be added for the series. Default is \code{TRUE}.}

\item{second_axis}{A logical value indicating if the series should be plotted on a secondary y-axis on the right side. Values will be scaled by default to the domain of the first y-axis.}
}
\value{
An object of class \code{htmlwidget} representing the plot with a series added.
}
\description{
This function adds additional series to an existing SveltePlot chart. It supports adding
lines or points with customizable aesthetics such as color, size, and opacity. This is particularly
useful for layering multiple data sets on a single plot for comparison or highlighting relationships.
}
\examples{
library(SveltePlots)
library(dplyr)
library(lubridate)

data("economics")
data("confidence_intervals")
data("purchases")

sp(
  data = economics,
  type = "line",
  mapping = spaes(x = date, y = unemploy),
  colors = "red"
) \%>\%
  sp_add_series(
    data = economics,
    mapping = spaes(x = date, y = pce),
    type = "line",
    colors = "green"
  ) \%>\%
  sp_add_series(
    data = economics,
    mapping = spaes(x = date, y = psavert),
    type = "line",
    colors = "blue"
  )

data("gapminder")

gapminder <- gapminder \%>\%
  dplyr::mutate(
    country = as.character(country),
    year = lubridate::ymd(paste0(year, "-01-01"))
  )

sp <- SveltePlots::sp(
  data = gapminder \%>\%
    dplyr::group_by(year, continent) \%>\%
    dplyr::summarise(
      lifeExp = mean(lifeExp)
    ) \%>\%
    dplyr::ungroup(),
  mapping = spaes(x = year, y = lifeExp, group = continent),
  type = "line",
  combine_same_groups = FALSE
) \%>\%
  sp_add_series(
    data = gapminder \%>\%
      dplyr::filter(country == "Germany"),
    mapping = spaes(x = year, y = lifeExp, group = country),
    type = "line",
    colors = "gold"
  ) \%>\%
  sp_add_series(
    gapminder \%>\%
      dplyr::filter(country == "Chile"),
    mapping = spaes(x = year, y = lifeExp, group = country),
    type = "line",
    colors = "silver"
  ) \%>\%
  sp_add_series(
    gapminder \%>\%
      dplyr::filter(country == "Chile"),
    mapping = spaes(x = year, y = lifeExp, group = country),
    type = "points",
    size = 3,
    tooltip = FALSE
  )

sp(
  data = purchases,
  mapping = spaes(x = date, y = revenue_roll, group = age),
  type = "line",
  colors = c("red", "green", "blue"),
  combine_same_groups = FALSE
) \%>\%
  sp_add_series(
    data = purchases,
    mapping = spaes(x = date, y = revenue, group = age),
    type = "points",
    alpha = 0.4,
    tooltip = FALSE,
  ) \%>\%
  sp_add_series(
    data = purchases[purchases$revenue == max(purchases$revenue), ],
    mapping = spaes(x = date, y = revenue, group = age),
    type = "points",
    size = 5,
    tooltip = FALSE
  )
}
