% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_setFOR_fdown}
\alias{seasonder_setFOR_fdown}
\title{Set FOR Dropoff Threshold (fdown)}
\usage{
seasonder_setFOR_fdown(seasonder_cs_object, fdown)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object with FOR parameters.}

\item{fdown}{A numeric value specifying the new dropoff threshold.}
}
\value{
The updated SeaSondeRCS object with the new \code{fdown} value.
}
\description{
This function sets the power dropoff threshold (\code{fdown}) used to define the lower limit of the first-order region.
}
\examples{
# Set sample file paths
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
# Read the antenna pattern file to create a SeaSondeRAPM object
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
# Create a SeaSondeRCS object from a spectral file
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_setFOR_fdown(cs_obj, 12)
}
