% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_runMUSIC}
\alias{seasonder_runMUSIC}
\title{Execute the MUSIC Algorithm on a SeaSondeRCS Object}
\usage{
seasonder_runMUSIC(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object that contains the radar cross-spectrum data
and metadata. This object is modified in place to include the results of the MUSIC algorithm.}
}
\value{
A \code{SeaSondeRCS} object with updated MUSIC-related attributes. Specifically:
\itemize{
\item Processing steps annotated with the MUSIC start and end points.
\item Updated attributes and fields for covariance matrix computations, DOA estimations, and other MUSIC-related metrics.
}
}
\description{
This function performs the MUSIC (MUltiple SIgnal Classification) algorithm on a given
SeaSondeRCS object, executing a series of processing steps to extract direction-of-arrival (DOA) information
and other related metrics from the radar cross-spectrum data.
}
\details{
The MUSIC algorithm is executed in a series of sequential steps:
\enumerate{
\item Log the start of the MUSIC algorithm.
\item Update the processing steps of the \code{SeaSondeRCS} object to include the MUSIC start text.
\item Perform the following computations:
\itemize{
\item Compute the covariance matrix from the cross-spectrum data.
\item Perform eigen decomposition on the covariance matrix.
\item Compute the DOA functions using MUSIC-specific methods.
\item Extract peaks from the DOA functions, corresponding to possible signal directions.
\item Calculate the signal power matrix.
\item Test for dual solutions and compute their proportions.
\item Select the final set of DOAs from the computed data.
\item Convert the selected DOAs to geographical coordinates (latitude and longitude).
}
\item Log the completion of the MUSIC algorithm.
}
}
\examples{
\donttest{
# Prepare a SeaSondeRCS object with MUSIC data
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
cs_obj <- seasonder_initMUSICData(cs_obj)
cs_obj <- seasonder_initMUSICData(
 cs_obj,
 range_cells = c(rep(5,11), rep(4,11)),
 doppler_bins = c(c(669:679),c(674:684))
)
cs_obj <- seasonder_SeaSondeRCSMUSICInterpolateDoppler(cs_obj)
# Run the MUSIC algorithm
cs_obj <- seasonder_runMUSIC(cs_obj)
# Check the updated processing steps
print(seasonder_getSeaSondeRCS_ProcessingSteps(cs_obj))
}
}
\seealso{
\code{\link{seasonder_MUSICComputeCov}}: Compute the covariance matrix.
\code{\link{seasonder_MUSICCovDecomposition}}: Perform eigen decomposition of the covariance matrix.
\code{\link{seasonder_MUSICComputeDOAProjections}}: Compute the direction-of-arrival functions.
\code{\link{seasonder_MUSICExtractPeaks}}: Extract peaks from the DOA functions.
\code{\link{seasonder_MUSICComputeSignalPowerMatrix}}: Calculate the signal power matrix.
\code{\link{seasonder_MUSICTestDualSolutions}}: Test and analyze dual solutions in the DOA.
\code{\link{seasonder_MUSICComputePropDualSols}}: Compute proportions for dual solutions.
\code{\link{seasonder_MUSICSelectDOA}}: Select final DOA estimations.
\code{\link{seasonder_MUSIC_LonLat}}: Convert DOA estimations to geographical coordinates.
}
