% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_createSeaSondeRCS.list}
\alias{seasonder_createSeaSondeRCS.list}
\title{Create a SeaSondeRCS object from a list}
\usage{
\method{seasonder_createSeaSondeRCS}{list}(x, specs_path = NULL, ...)
}
\arguments{
\item{x}{A list with components \code{header} and \code{data} required for constructing the SeaSondeRCS object.}

\item{specs_path}{Not used for list inputs.}

\item{...}{Additional parameters that may be used for setting object attributes.}
}
\value{
A SeaSondeRCS object.
}
\description{
This method creates a SeaSondeRCS object directly from a list containing the header and data.
}
\details{
The function creates a new SeaSondeRCS object using \code{new_SeaSondeRCS} with the provided header and data.
It then appends a processing step, generated by \code{SeaSondeRCS_creation_step_text("list")}, to the object via
\code{seasonder_setSeaSondeRCS_ProcessingSteps}.
}
\examples{
# Given a list with header and data, create a SeaSondeRCS object
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
specs_path <- seasonder_defaultSpecsFilePath("CS")
temp_obj <- seasonder_readSeaSondeCSFile(cs_file, specs_path)
cs_list <- list(header = temp_obj$header, data = temp_obj$data)
rcs_object <- seasonder_createSeaSondeRCS(cs_list)
}
\seealso{
\code{\link{new_SeaSondeRCS}},
\code{\link{seasonder_setSeaSondeRCS_ProcessingSteps}},
\code{\link{SeaSondeRCS_creation_step_text}}
}
