% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRAPM.R
\name{seasonder_createSeaSondeRAPM}
\alias{seasonder_createSeaSondeRAPM}
\title{Create a SeaSondeRAPM Object}
\usage{
seasonder_createSeaSondeRAPM(
  calibration_matrix = matrix(complex(real = NA_real_, imaginary = NA_real_), nrow = 3,
    ncol = 0),
  ...
)
}
\arguments{
\item{calibration_matrix}{A 3 x b complex matrix, where b is the number of bearings for calibration.}

\item{...}{Additional named attributes that will be passed to \code{\link{seasonder_initializeAttributesSeaSondeRAPM}}.}
}
\value{
A SeaSondeRAPM object containing a complex matrix with class attribute 'SeaSondeRAPM' and
additional attributes for metadata. Row names are set "A13", "A23" and "A33" and column names are set to be the values in BEAR.
}
\description{
This function creates a SeaSondeRAPM object to store antenna pattern calibration data.
}
\details{
The function performs the following operations:
\enumerate{
\item Validates the \code{calibration_matrix} with \code{\link{seasonder_validateCalibrationMatrixSeaSondeRAPM}}.
\item Initializes all other attributes either with default or user-provided values.
\item Merges the initialized attributes into \code{calibration_matrix}.
\item Sets the object's class to 'SeaSondeRAPM'.
}

For more details on the attributes, see \code{\link{seasonder_initializeAttributesSeaSondeRAPM}}.
}
\examples{
  # Create a test SeaSondeRAPM object by reading sample file
  apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
  obj <- seasonder_readSeaSondeRAPMFile(apm_file)
}
\seealso{
\code{\link{seasonder_validateCalibrationMatrixSeaSondeRAPM}},
\code{\link{seasonder_initializeAttributesSeaSondeRAPM}}
}
