% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_computeFORsSeaSondeMethod}
\alias{seasonder_computeFORsSeaSondeMethod}
\title{Compute First Order Regions (FOR) Using the SeaSonde Method}
\usage{
seasonder_computeFORsSeaSondeMethod(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the spectral data and configuration parameters.}
}
\value{
The updated \code{SeaSondeRCS} object with the computed First Order Regions (FOR).
}
\description{
This function processes a SeaSondeRCS object to compute the First Order Regions (FOR)
using the SeaSonde method. The workflow includes detecting null points, filtering amplitudes,
limiting currents to a maximum range, and rejecting peaks based on proximity to Bragg indices
and noise/ionospheric contamination.
}
\details{
\strong{Workflow Steps:}
\enumerate{
\item \strong{Initialize Processing Steps:}
\itemize{
\item Marks the start of the SeaSonde method processing in the object's metadata.
}
\item \strong{Detect Null Points:}
\itemize{
\item Locates the nulls defining the First Order Regions (FOR) using \code{\link{seasonder_findFORNulls}}.
}
\item \strong{Filter Amplitudes:}
\itemize{
\item Removes regions with insufficient amplitudes using \code{\link{seasonder_filterFORAmplitudes}}.
}
\item \strong{Limit Currents to Maximum Range:}
\itemize{
\item Ensures that currents exceed the configured maximum radial velocity using \code{\link{seasonder_limitFORCurrentRange}}.
}
\item \strong{Reject Distant Bragg Peaks:}
\itemize{
\item If enabled, rejects peaks that are too far from Bragg indices using \code{\link{seasonder_rejectDistantBragg}}.
}
\item \strong{Reject Noise/Ionospheric Peaks:}
\itemize{
\item If enabled, removes peaks where non-Bragg power significantly exceeds Bragg power using \code{\link{seasonder_rejectNoiseIonospheric}}.
}
\item \strong{Finalize Processing Steps:}
\itemize{
\item Marks the end of the SeaSonde method processing in the object's metadata.
}
}

\strong{Use Case:}
This function is designed for processing SeaSonde radar data to accurately identify and validate the
First Order Regions, ensuring reliable current and wave measurements.
}
\seealso{
\itemize{
\item \code{\link{seasonder_findFORNulls}} for detecting nulls in the FOR.
\item \code{\link{seasonder_filterFORAmplitudes}} for amplitude filtering.
\item \code{\link{seasonder_limitFORCurrentRange}} for limiting radial velocity.
\item \code{\link{seasonder_rejectDistantBragg}} for rejecting distant Bragg peaks.
\item \code{\link{seasonder_rejectNoiseIonospheric}} for rejecting noise/ionospheric contamination.
}
}
