% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCSSY.R
\name{seasonder_CSSY_read_csign}
\alias{seasonder_CSSY_read_csign}
\title{Read Complex Spectral Sign Information from a Connection}
\usage{
seasonder_CSSY_read_csign(connection, key)
}
\arguments{
\item{connection}{A binary connection to read raw bytes from.}

\item{key}{A list containing:
\describe{
\item{size}{An integer specifying the total number of bytes to be read. It must equal 6 times the number
of bytes per group.}
\item{key}{A string identifier (expected to be \code{"csign"}).}
}}
}
\value{
A named list of 6 vectors. Each vector represents one group (e.g., \code{C13r}, \code{C13i}, etc.)
and contains integers (0 or 1) corresponding to the bits (in little-endian order) extracted from the raw data.
}
\description{
This function reads a raw binary stream from a provided connection, expecting a specific format
that contains the sign bits for complex spectral values. The data is divided into 6 groups corresponding
to: \code{C13r}, \code{C13i}, \code{C23r}, \code{C23i}, \code{C12r}, and \code{C12i}.
}
\details{
The function performs the following steps:
\itemize{
\item Reads \code{key$size} bytes from the specified connection.
\item Checks if enough bytes were read.
\item Ensures that the total number of bytes is divisible by 6, allowing equal distribution among the groups.
\item Splits the raw byte vector into 6 groups based on the calculated number of bytes per group.
\item Converts each byte into its 8-bit representation (using \code{rawToBits}) and flattens the result.
}
}
