% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_getMUSICInterpolatedData}
\alias{seasonder_getMUSICInterpolatedData}
\title{Retrieve Interpolated MUSIC Data from a SeaSondeRCS Object}
\usage{
seasonder_getMUSICInterpolatedData(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object containing interpolated MUSIC data as an attribute.}
}
\value{
A list representing the interpolated cross-spectra data.
}
\description{
This function extracts the interpolated MUSIC cross-spectra data from a SeaSondeRCS object.
}
\details{
The function first checks if the interpolated data is set in the MUSIC_data attribute.
If absent, it initializes the data with \code{seasonder_MUSICInitInterpolatedData()}.
}
\examples{
# Minimal example for seasonder_getMUSICInterpolatedData
cs_file <- system.file("css_data/CSS_TORA_24_04_04_0700.cs", package = "SeaSondeR")
apm_file <- system.file("css_data/MeasPattern.txt", package = "SeaSondeR")
apm_obj <- seasonder_readSeaSondeRAPMFile(apm_file)
cs_obj <- seasonder_createSeaSondeRCS(cs_file, seasonder_apm_object = apm_obj)
interp_data <- seasonder_getMUSICInterpolatedData(cs_obj)
str(interp_data)
}
