% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getBraggWaveLength}
\alias{seasonder_getBraggWaveLength}
\title{Calculate the Bragg Wavelength}
\usage{
seasonder_getBraggWaveLength(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the necessary data
to compute the radar wavelength.}
}
\value{
A numeric value representing the Bragg wavelength (in meters).
}
\description{
This function computes the Bragg wavelength \eqn{\lambda_B} for a SeaSonde radar
system. The Bragg wavelength is defined as half the radar wavelength and is used
to identify the fundamental scattering mechanisms in oceanographic radar measurements.
}
\details{
The Bragg wavelength \eqn{\lambda_B} is calculated as:
\eqn{\lambda_B = \frac{\lambda}{2}}
where:
\itemize{
\item \eqn{\lambda} is the radar wavelength in meters, obtained using
\code{\link{seasonder_getRadarWaveLength}}.
}

The Bragg wavelength is a critical parameter in interpreting the resonance
scattering from the sea surface, which is fundamental to the operation of
HF radar systems.
}
\seealso{
\code{\link{seasonder_getRadarWaveLength}} to compute the radar wavelength.
}
