% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getBraggLineBins}
\alias{seasonder_getBraggLineBins}
\title{Get Bragg Line Doppler Bins}
\usage{
seasonder_getBraggLineBins(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{A SeaSonde Cross Spectra (CS) object created by \code{seasonder_createSeaSondeRCS()}.
This object contains the metadata required for the computation, including
the normalized Doppler frequencies and their mapping to Doppler bins.}
}
\value{
A numeric vector of length 2, where:
\itemize{
\item The first value is the Doppler bin corresponding to the -1 Bragg frequency.
\item The second value is the Doppler bin corresponding to the 1 Bragg frequency.
}
}
\description{
This function calculates the Doppler bin indices corresponding to the first-order
Bragg frequencies (-1 and 1) for a SeaSonde Cross Spectra (CS) object.
}
\details{
This function uses the normalized Doppler frequencies for the first-order Bragg peaks
(\eqn{-1} and \eqn{1}) and maps them to their corresponding Doppler bin indices.
The mapping is performed using the helper function \code{seasonder_NormalizedDopplerFreq2Bins()},
which converts normalized frequencies to bin indices based on the spectral resolution
and the Doppler range of the radar system.

The bins are critical for identifying the Doppler shifts associated with the first-order
Bragg scattering in HF radar systems, which correspond to surface waves with wavelengths
half that of the transmitted radar signal.
}
\seealso{
\code{\link{seasonder_NormalizedDopplerFreq2Bins}} for the frequency-to-bin mapping logic.
}
