% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_MUSICExtractPeaks}
\alias{seasonder_MUSICExtractPeaks}
\title{Extract and Validate DOA Peaks Using MUSIC Algorithm}
\usage{
seasonder_MUSICExtractPeaks(seasonder_cs_object)
}
\arguments{
\item{seasonder_cs_object}{An object of class \code{SeaSondeRCS} containing cross-spectra data processed with the MUSIC algorithm.}
}
\value{
An updated \code{SeaSondeRCS} object with the following fields modified:
\itemize{
\item \code{MUSIC}: Contains the extracted DOA solutions.
\item \code{ProcessingSteps}: Includes a log of the peak extraction process.
}
}
\description{
This function processes a \code{SeaSondeRCS} object to extract Direction of Arrival (DOA) solutions using the MUSIC algorithm
and validates the retained solutions based on the extracted peaks.
}
\details{
The function performs the following operations:
\enumerate{
\item Initializes the peak extraction process and logs the start.
\item Extracts DOA solutions for each set of projections using \code{\link{seasonder_MUSICExtractDOASolutions}}.
\item Validates and adjusts the retained solution types using \code{\link{seasonder_MUSICExtractPeaksCheckRetainedSolution}}.
\item Updates the \code{SeaSondeRCS} object with the extracted and validated solutions.
\item Logs the completion of the peak extraction process.
}

The MUSIC algorithm's implementation follows the theoretical framework outlined by Paolo and Terril (2007), emphasizing the identification of signal directions
in HF radar cross-spectra.
}
\references{
Paolo, S., & Terril, E. (2007). Detection and characterization of signals in HF radar cross-spectra using the MUSIC algorithm.
\emph{Journal of Atmospheric and Oceanic Technology}.
}
\seealso{
\code{\link{seasonder_MUSICExtractDOASolutions}}, \code{\link{seasonder_MUSICExtractPeaksCheckRetainedSolution}}
}
