% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCSSY.R
\name{seasonder_CSSY_read_asign}
\alias{seasonder_CSSY_read_asign}
\title{Read Self Spectra Sign Information from a Connection}
\usage{
seasonder_CSSY_read_asign(connection, key)
}
\arguments{
\item{connection}{A binary connection to read raw bytes from.}

\item{key}{A list containing:
\describe{
\item{size}{An integer specifying the total number of bytes to be read. It must equal 3 times the number
of bytes per group.}
\item{key}{A string identifier (expected to be \code{"asign"}).}
}}
}
\value{
A named list of 3 vectors. Each vector represents one group (i.e., \code{cs1a}, \code{cs2a}, \code{cs3a})
and contains integers (0 or 1) corresponding to the bits (in little-endian order) extracted from the raw data.
}
\description{
This function reads a raw binary stream from a provided connection, expecting a specific format
that contains the sign bits for self spectra values. The data is divided into 3 groups corresponding
to: \code{cs1a}, \code{cs2a}, and \code{cs3a}.
}
