% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_year.R
\name{flag_year}
\alias{flag_year}
\title{Flag records outside a year range}
\usage{
flag_year(
  occ,
  year_column = "year",
  lower_limit = NULL,
  upper_limit = NULL,
  flag_NA = FALSE
)
}
\arguments{
\item{occ}{(data.frame) a dataset with occurrence records, preferably
standardized using \code{format_columns()}. Must contain the column specified in
\code{year_column}.}

\item{year_column}{(character) name of the column containing the year in
which the occurrence was recorded. This column must be numeric.}

\item{lower_limit}{(numeric) the minimum acceptable year. Records collected
before this value will be flagged. Default is \code{NULL}.}

\item{upper_limit}{(numeric) the maximum acceptable year. Records collected
after this value will be flagged. Default is \code{NULL}.}

\item{flag_NA}{(character) whether to flag records with missing year
information. Default is \code{FALSE}.}
}
\value{
A data.frame identical to \code{occ} but with an additional column named
\code{year_flag}. Records collected outside the year range specified are assigned
\code{FALSE}.
}
\description{
This function identifies occurrence records collected before or after
user-specified years.
}
\examples{
# Load example data
data("occurrences", package = "RuHere")
# Flag records collected before 1980 and after 2010
occ_year <- flag_year(occ = occurrences, lower_limit = 1980,
                      upper_limit = 2010)
}
