% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ResIN.R
\name{as.gephi.ResIN}
\alias{as.gephi.ResIN}
\title{Coerce a ResIN object to Gephi CSV table(s)}
\usage{
\method{as.gephi}{ResIN}(
  x,
  file = "ResIN_gephi.csv",
  edges_only = TRUE,
  dont_save_csv = FALSE,
  weight_col = "weight",
  ...
)
}
\arguments{
\item{x}{A \code{ResIN} object.}

\item{file}{Output file name (legacy style).}

\item{edges_only}{Logical; if TRUE write/return only edges.}

\item{dont_save_csv}{Logical; set TRUE to disable writing.}

\item{weight_col}{Name of the edge-weight column in \code{x$ResIN_edgelist}.}

\item{...}{Ignored.}
}
\value{
If \code{edges_only = TRUE}, an edge table data.frame. Otherwise a list with \code{edges} and \code{nodes}. “When \code{dont_save_csv = FALSE}, the return value is returned invisibly.”
}
\description{
Produces Gephi-readable edge (and optionally node) tables from a \code{ResIN}
object and (by default) writes them to CSV. Set \code{dont_save_csv = TRUE}
to return tables without writing files.
}
\examples{
## Load the 12-item simulated Likert-type ResIN toy dataset
data(lik_data)

## Estimate a ResIN network
res <- ResIN(lik_data, plot_ggplot = FALSE)

## Create Gephi edge table without writing files
edges <- as.gephi(res, dont_save_csv = TRUE)
head(edges)

\dontrun{
## Write CSV file(s) for import to Gephi
## (writes "ResIN_gephi.csv" by default)
as.gephi(res, file = "ResIN_gephi.csv")

## Write both edges and nodes tables
## (writes "ResIN_gephi_edges.csv" and "ResIN_gephi_nodes.csv")
as.gephi(res, file = "ResIN_gephi.csv", edges_only = FALSE)
}


}
