% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResIN_boots_prepare.R
\name{ResIN_boots_prepare}
\alias{ResIN_boots_prepare}
\title{Create a bootstrap plan for re-estimating ResIN objects to derive statistical uncertainty estimates}
\usage{
ResIN_boots_prepare(
  ResIN_object,
  n = 10000,
  boots_type = "resample",
  resample_size = NULL,
  weights = NULL,
  save_input = FALSE,
  seed_boots = 42
)
}
\arguments{
\item{ResIN_object}{A ResIN object to prepare bootstrapping workflow.}

\item{n}{Bootstrapping sample size. Defaults to 10.000.}

\item{boots_type}{What kind of bootstrapping should be performed? If set to "resample", function performs row-wise re-sampling of raw data (useful for e.g., sensitivity or power analysis). If set to "permute", function will randomly reshuffle raw item responses (useful e.g., for simulating null-hypothesis distributions). Defaults to "resample".}

\item{resample_size}{Optional parameter determining sample size when \code{boots_type} is set to "resample". Defaults of to number of rows in raw data.}

\item{weights}{An optional weights vector that can be used to adjust the re-sampling of observations. Should either be NULL (default) or a positive numeric vector of the same length as the original data.}

\item{save_input}{Should all input information for each bootstrap iteration (including re-sampled/permuted data) be stored. Set to FALSE by default to save a lot of memory and disk storage.}

\item{seed_boots}{Random seed for bootstrap samples}
}
\value{
An object of class \code{"ResIN_boots_prepped"} containing a bootstrap plan
(specification) used by \code{\link{ResIN_boots_execute}}.
Use \code{print()}, \code{summary()}, \code{length()}, and \code{[}
to inspect or subset the plan. See \code{\link{ResIN_boots_prepped}} for details.
}
\description{
Provides instructions for how to bootstrap a ResIN network to derive uncertainty estimates around core quantities of interest. Requires output of \code{ResIN} function.
}
\examples{
## Load the 12-item simulated Likert-type toy dataset
data(lik_data)

# Apply the ResIN function to toy Likert data:
ResIN_obj <- ResIN(lik_data, network_stats = TRUE,
                      generate_ggplot = FALSE, plot_ggplot = FALSE)

\donttest{
# Prepare for bootstrapping
prepped_boots <- ResIN_boots_prepare(ResIN_obj, n=100, boots_type="resample")

# Execute the prepared bootstrap list
executed_boots <-  ResIN_boots_execute(prepped_boots, parallel = TRUE, detect_cores = TRUE)

# Extract results - here for example, the network (global)-clustering coefficient
ResIN_boots_extract(executed_boots, what = "global_clustering", summarize_results = TRUE)
}

}
