% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_advanced.R
\name{sparse_projection_cpd}
\alias{sparse_projection_cpd}
\title{Sparse Projection Changepoint Detection}
\usage{
sparse_projection_cpd(
  data,
  n_projections = 10,
  penalty = "bic",
  min_segment = 5,
  sparsity = 0.3
)
}
\arguments{
\item{data}{Matrix with rows = observations, columns = dimensions}

\item{n_projections}{Number of random projections (default: 10)}

\item{penalty}{Penalty for changepoints}

\item{min_segment}{Minimum segment length}

\item{sparsity}{Sparsity level for projections (fraction of non-zeros)}
}
\value{
List with changepoints and projection information
}
\description{
Detects changepoints in high-dimensional data using random sparse
projections to reduce dimensionality while preserving changepoint
structure.
}
\references{
Wang, D. and Bhattacharjee, M. (2021). High-dimensional changepoint
estimation via sparse projection. arXiv preprint.
}
