% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_bayesian.R
\name{shiryaev_roberts}
\alias{shiryaev_roberts}
\title{Shiryaev-Roberts Changepoint Detection}
\usage{
shiryaev_roberts(
  data,
  type = "mean",
  prior = NULL,
  hazard = NULL,
  threshold = 100,
  mu0 = NULL,
  mu1 = NULL,
  sigma = NULL,
  ...
)
}
\arguments{
\item{data}{Numeric vector}

\item{type}{Type of change to detect}

\item{prior}{Prior specification}

\item{hazard}{Hazard prior}

\item{threshold}{Detection threshold}

\item{mu0}{Pre-change mean (if known)}

\item{mu1}{Post-change mean (if known)}

\item{sigma}{Known standard deviation (if applicable)}

\item{...}{Additional arguments}
}
\value{
List with changepoints and statistics
}
\description{
Implements the Shiryaev-Roberts procedure, which is asymptotically optimal
for detecting changes with minimal detection delay.
}
\examples{
data <- c(rnorm(100), rnorm(100, mean = 1))
result <- shiryaev_roberts(data)

}
\references{
Shiryaev, A. N. (1963). On Optimum Methods in Quickest Detection Problems.
Theory of Probability and Its Applications.
}
