% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate Changepoint Detection Results}
\usage{
evaluate(result, true_changepoints, n = NULL, tolerance = 5)
}
\arguments{
\item{result}{A regime_result object or vector of changepoint locations}

\item{true_changepoints}{Vector of true changepoint locations}

\item{n}{Total number of observations (required if result is a vector)}

\item{tolerance}{Tolerance window for matching changepoints (for F1 score)}
}
\value{
A list of class "regime_evaluation" containing all metrics
}
\description{
Comprehensive evaluation of detection results against known ground truth.
Computes multiple metrics for localization, segmentation, and detection.
}
\examples{
true_cp <- c(50, 100)
data <- c(rnorm(50), rnorm(50, mean = 2), rnorm(50))

result <- detect_regimes(data)
evaluation <- evaluate(result, true_cp)
print(evaluation)

}
