% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_bayesian.R
\name{bocpd}
\alias{bocpd}
\title{Bayesian Online Changepoint Detection}
\usage{
bocpd(
  data,
  type = "both",
  prior = NULL,
  hazard = NULL,
  threshold = 0.3,
  truncate_run_length = NULL,
  ...
)
}
\arguments{
\item{data}{Numeric vector or matrix}

\item{type}{Type of change to detect (currently supports "both")}

\item{prior}{Prior specification (from normal_gamma(), normal_known_var(), etc.)}

\item{hazard}{Hazard prior (from geometric_hazard(), etc.) or numeric hazard rate}

\item{threshold}{Probability threshold for declaring a changepoint}

\item{truncate_run_length}{Maximum run length to track (for efficiency)}

\item{...}{Additional arguments}
}
\value{
List containing:
\itemize{
\item changepoints: Detected changepoint locations
\item posterior: Matrix of run length posteriors over time
\item prob_change: Probability of changepoint at each time
\item map_run_length: Maximum a posteriori run length at each time
}
}
\description{
Implements the BOCPD algorithm of Adams and MacKay (2007).
Maintains a posterior distribution over the run length (time since
last changepoint) and updates it online as new observations arrive.
}
\examples{
data <- c(rnorm(100, mean = 0), rnorm(100, mean = 3))

result <- bocpd(data)

result <- bocpd(data, prior = normal_gamma(mu0 = 0, kappa0 = 1,
                                            alpha0 = 1, beta0 = 1))


result <- bocpd(data, hazard = 0.01)

}
\references{
Adams, R. P. and MacKay, D. J. C. (2007). Bayesian Online Changepoint Detection.
arXiv:0710.3742
}
