"_PACKAGE"

utils::globalVariables(c(
  "time", "value", "segment", "prob_change", "run_length",
  "changepoint", "ci_lower", "ci_upper", "method", "metric",
  ".", "n", "start", "end", "mean", "variance", "params"
))

.pkg_env <- new.env(parent = emptyenv())

#' @importFrom rlang .data
NULL

.onLoad <- function(libname, pkgname) {
  .pkg_env$julia_available <- FALSE
  .pkg_env$julia_initialized <- FALSE
  
  if (requireNamespace("JuliaCall", quietly = TRUE)) {
    tryCatch({
      .pkg_env$julia_available <- TRUE
    }, error = function(e) {
      .pkg_env$julia_available <- FALSE
    })
  }
  
  invisible()
}

.onAttach <- function(libname, pkgname) {
  packageStartupMessage(
    "RegimeChange: Regime Change Detection in Time Series\n",
    "Version ", utils::packageVersion("RegimeChange"), "\n",
    "Type ?detect_regimes to get started"
  )
  
  if (!.pkg_env$julia_available) {
    packageStartupMessage(
      "\nNote: Julia backend not available. Using R implementation.\n",
      "For better performance, install JuliaCall and Julia."
    )
  }
}