% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{rduckhts_load}
\alias{rduckhts_load}
\title{Load DuckHTS Extension}
\usage{
rduckhts_load(con, extension_path = NULL)
}
\arguments{
\item{con}{A DuckDB connection object}

\item{extension_path}{Optional path to the duckhts extension file. If NULL,
will try to use the bundled extension.}
}
\value{
TRUE if the extension was loaded successfully
}
\description{
Loads the DuckHTS extension into a DuckDB connection. This must be called
before using any of the HTS reader functions.
}
\details{
The DuckDB connection must be created with
\code{allow_unsigned_extensions = "true"}.
}
\examples{
library(DBI)
library(duckdb)

con <- dbConnect(duckdb::duckdb(config = list(allow_unsigned_extensions = "true")))
rduckhts_load(con)
dbDisconnect(con, shutdown = TRUE)

}
