% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duckhts.R
\name{extract_map_data}
\alias{extract_map_data}
\title{Extract MAP Keys and Values}
\usage{
extract_map_data(map_col, operation = "keys", default = NA)
}
\arguments{
\item{map_col}{A data frame column from DuckDB MAP data}

\item{operation}{What to extract: "keys", "values", or a specific key name}

\item{default}{Default value if key is not found (only used when operation is a key name)}
}
\value{
Extracted data based on the operation
}
\description{
Helper function to work with DuckDB MAP data (returned as data frames).
Can extract keys, values, or search for specific key-value pairs.
}
\examples{
library(DBI)
library(duckdb)

con <- dbConnect(duckdb::duckdb(config = list(allow_unsigned_extensions = "true")))
rduckhts_load(con)
gff_path <- system.file("extdata", "gff_file.gff.gz", package = "Rduckhts")
rduckhts_gff(con, "annotations", gff_path, attributes_map = TRUE, overwrite = TRUE)
data <- dbGetQuery(con, "SELECT attributes FROM annotations LIMIT 5")
keys <- extract_map_data(data$attributes, "keys")
name_values <- extract_map_data(data$attributes, "Name")
dbDisconnect(con, shutdown = TRUE)

}
