#' Print method for tscope.fit
#'
#' @description
#' Print method for objects of class \code{tscope.fit}
#'
#' @param x an object of class `"tscope.fit"`
#' @param ... Additional arguments (currently ignored).
#'
#' @return No return value, prints contents of the `"tscope.fit"` object.
#'
#' @method print tscope.fit
#' @export
print.tscope.fit <- function(x, ...) {
  x <- x
  attr(x, "class") <- NULL
  attr(x, "nx") <- NULL
  attr(x, "np") <- NULL
  attr(x, "f_stat") <- NULL

  print(x)
  invisible(x)
}
