#' Print method for tscope
#'
#' @description
#' Print method for objects of class \code{tscope}
#'
#' @param x an object of class `"tscope"`
#' @param ... Additional arguments (currently ignored).
#'
#' @return No return value, prints contents of the `"tscope"` object.
#'
#' @method print tscope
#' @export
print.tscope <- function(x, ...) {
  nx <- attr(x, "nx")
  np <- attr(x, "np")

  if(ncol(x) == 1) {
    x <- as.data.frame(x)
    divider1 <- data.frame(Est = strrep("-", 10))
    divider2 <- data.frame(Est = strrep("=", 10))
    colnames(x) <- c("Est")
  } else {
    divider1 <- data.frame(Est = strrep("-", 10),  boot.SE = strrep("-", 10),
                           "z value" = strrep("-", 10), "Pr(>|z|)"= strrep("-", 10))
    divider2 <- data.frame(Est = strrep("=", 10),  boot.SE = strrep("=", 10),
                           "z value" = strrep("=", 10), "Pr(>|z|)"= strrep("=", 10))
  }

  for(i in 1:ncol(x)){
    x[,i] <- sapply(x[,i], FUN = function(x) {
      if(x < 2e-16 & x > -2e-16) {
        return("< 2e-16")
      } else if(x < 1e-8 & x > -1e-8) {
        return(format(x, scientific = T))
      }
      as.character(round(x, 8))
    })
  }


  df_w_hot <- x[1:nx, , drop = FALSE] #W and higher order terms
  hot_rnames <- rownames(df_w_hot)
  rownames(df_w_hot) <- hot_rnames

  df_s1r <- x[(nx+1):(nx+np), ,drop = FALSE] #stage 1 residuals

  df_rest <- x[(nx+np+1):nrow(x), ,drop = FALSE] #cor and sigma

  colnames(divider1) <- colnames(x)
  rownames(divider1) <- strrep("-", max(nchar(rownames(x))))

  colnames(divider2) <- colnames(x)
  rownames(divider2) <- strrep("=", max(nchar(rownames(x))))

  final_df <- rbind(as.data.frame(df_w_hot), divider1, as.data.frame(df_s1r), divider2, as.data.frame(df_rest))
  print.data.frame(final_df)
  if(!is.null(attr(x, "f_stat"))){
    cat("\n Relevance Test: \n")
    print(attr(x, "f_stat"), row.names = F)
  } else if((nx-1) != np) {
    message("No pair of endogenous and exogenous variables were significant in the relevance test.")
  }
}









