#' Print method for CCF
#'
#' @description
#' Print method for objects of class \code{ccf}
#'
#' @param x an object of class `"ccf"`
#' @param ... Additional arguments (currently ignored).
#' 
#' @return No return value, prints contents of the `"ccf"` object.
#'
#' @method print ccf
#' @export
print.ccf <- function(x, ...){
  class(x) <- setdiff(class(x), "ccf")

  attr(x, "class") <- NULL
  attr(x, "other_attr_you_don't_want") <- NULL

  attributes(x) <- attributes(x)[names(attributes(x)) %in% "names"]

  print.default(x)
  x
}
