% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_table.R
\name{base_table}
\alias{base_table}
\title{Create a Summary Table with Grouping and Custom Formatting}
\usage{
base_table(
  data1,
  show_missing_data,
  by_group = FALSE,
  var_group,
  quali = NULL,
  quanti = NULL,
  stat_var_quanti = c("{mean} ({sd})", "{median} ({p25}; {p75})", "{min}; {max}"),
  digits = list(r_quanti = 1, r_quali = 1)
)
}
\arguments{
\item{data1}{A data frame containing the data to summarize.}

\item{show_missing_data}{Should the missing data be displayed. Can be either :
\itemize{
\item \code{FALSE}: No missing data displayed
\item \code{TRUE}(default): Missing data displayed
}}

\item{by_group}{A boolean (default is FALSE) to analyse by group.}

\item{var_group}{A string or NULL, the variable to group by (optional).
If NULL, no grouping will be applied.}

\item{quali}{A character vector, the names of categorical variables to
treat as categorical in the summary table.}

\item{quanti}{A character vector, the names of continuous variables to
treat as continuous in the summary table.}

\item{stat_var_quanti}{A character vector specifying the statistics to display for continuous variables. Default is \code{c("{mean} ({sd})", "{median} ({p25}; {p75})", "{min}; {max}")}.}

\item{digits}{A list, the number of decimal places to round categorical and
continuous variable. Default is list(r_quanti = 1, r_quali = 1)}
}
\value{
A \code{gtsummary} table summarizing the specified variables,
grouped by \code{var_group} if provided, with customizable statistics
and rounding options.
}
\description{
This function generates a summary table from a data frame with specified
grouping and variable types. It uses the \code{gtsummary} package to create
descriptive statistics for categorical and continuous variables, with
options for customizing the rounding and labels.
}
\examples{
# Example usage with the iris dataset
base_table(iris, var_group = "Species", show_missing_data = TRUE)

}
