/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;

public class SerializedInstancesLoader
extends AbstractFileLoader
implements BatchConverter,
IncrementalConverter {
    static final long serialVersionUID = 2391085836269030715L;
    public static String FILE_EXTENSION = Instances.SERIALIZED_OBJ_FILE_EXTENSION;
    protected Instances m_Dataset = null;
    protected int m_IncrementalIndex = 0;

    public String globalInfo() {
        return "Reads a source that contains serialized Instances.";
    }

    public void reset() {
        this.m_Dataset = null;
        this.m_IncrementalIndex = 0;
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    public String getFileDescription() {
        return "Binary serialized instances";
    }

    public void setSource(InputStream inputStream) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(inputStream));
        try {
            this.m_Dataset = (Instances)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Could not deserialize instances from this source.");
        }
    }

    public Instances getStructure() throws IOException {
        if (this.m_Dataset == null) {
            throw new IOException("No source has been specified");
        }
        return new Instances(this.m_Dataset, 0);
    }

    public Instances getDataSet() throws IOException {
        if (this.m_Dataset == null) {
            throw new IOException("No source has been specified");
        }
        return this.m_Dataset;
    }

    public Instance getNextInstance() throws IOException {
        if (this.m_Dataset == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_IncrementalIndex == this.m_Dataset.numInstances()) {
            return null;
        }
        return this.m_Dataset.instance(this.m_IncrementalIndex++);
    }

    public static void main(String[] stringArray) {
        SerializedInstancesLoader.runFileLoader(new SerializedInstancesLoader(), stringArray);
    }
}

