% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_qq_3d}
\alias{plot_qq_3d}
\title{3D Surface Plot for QQ Regression}
\usage{
plot_qq_3d(
  qq_result,
  type = c("coefficient", "rsquared", "pvalue"),
  colorscale = c("Jet", "BlueRed", "Viridis", "Plasma"),
  show_contour = TRUE,
  x_label = "X Quantile (tau)",
  y_label = "Y Quantile (theta)",
  title = NULL,
  aspect_ratio = c(1, 1, 0.7),
  camera = list(eye = list(x = 1.4, y = 1.7, z = 1.2))
)
}
\arguments{
\item{qq_result}{An object of class "qq_regression" or a data frame
with columns: y_quantile, x_quantile, coefficient, r_squared, p_value.}

\item{type}{Character string. Type of values to plot: "coefficient"
(default), "rsquared", or "pvalue".}

\item{colorscale}{Character string. Color scale to use. Options are:
\itemize{
  \item "Jet" - MATLAB-style rainbow (default)
  \item "BlueRed" - Blue to red diverging scale
  \item "Viridis" - Viridis perceptually uniform scale
  \item "Plasma" - Plasma perceptually uniform scale
}}

\item{show_contour}{Logical. If \code{TRUE}, shows gridlines on the
surface. Default is \code{TRUE}.}

\item{x_label}{Character string. Label for x-axis. Default is
"X Quantile (tau)".}

\item{y_label}{Character string. Label for y-axis. Default is
"Y Quantile (theta)".}

\item{title}{Character string. Plot title. If \code{NULL}, an
automatic title is generated.}

\item{aspect_ratio}{Numeric vector of length 3. Aspect ratio for
x, y, z axes. Default is c(1, 1, 0.7).}

\item{camera}{List. Camera position settings for plotly. Default
provides a good viewing angle.}
}
\value{
A plotly object representing the 3D surface plot.
}
\description{
Creates an interactive 3D surface plot of QQ regression results using
plotly. Supports multiple color scales including MATLAB-style Jet.
}
\details{
The function creates an interactive 3D surface plot where:
\itemize{
  \item X-axis: Quantiles of the independent variable (tau)
  \item Y-axis: Quantiles of the dependent variable (theta)
  \item Z-axis: Estimated coefficients, R-squared, or p-values
}

The Jet colorscale mimics MATLAB's default color scheme for surface
plots, transitioning from blue through cyan, green, yellow to red.
}
\examples{
# Generate example data
set.seed(42)
n <- 200
x <- rnorm(n)
y <- 0.5 * x + rnorm(n, sd = 0.5)

# Run QQ regression
result <- qq_regression(y, x, verbose = FALSE)

\donttest{
# Create 3D surface plot of coefficients
plot_qq_3d(result, type = "coefficient", colorscale = "Jet")

# Create plot of R-squared values
plot_qq_3d(result, type = "rsquared", colorscale = "Viridis")
}

}
