% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBirthDay.R
\name{addBirthdayQuery}
\alias{addBirthdayQuery}
\title{Add the birth day of an individual to a table}
\usage{
addBirthdayQuery(
  x,
  birthdayName = "birthday",
  birthday = 0,
  ageMissingMonth = 1,
  ageMissingDay = 1,
  ageImposeMonth = FALSE,
  ageImposeDay = FALSE
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{birthdayName}{Birth day variable name.}

\item{birthday}{Number of birth day.}

\item{ageMissingMonth}{Month of the year assigned to individuals with missing
month of birth.}

\item{ageMissingDay}{day of the month assigned to individuals
with missing day of birth.}

\item{ageImposeMonth}{TRUE or FALSE. Whether the month of the date of birth
will be considered as missing for all the individuals.}

\item{ageImposeDay}{TRUE or FALSE. Whether the day of the date of birth
will be considered as missing for all the individuals.}
}
\value{
The table with a query that add the new column containing the birth
day.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Same as \code{addBirthday()}, except query is not computed to a table.

The function accounts for leap years and corrects the invalid dates to the
next valid date.
}
\examples{
\donttest{
library(PatientProfiles)
library(dplyr)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addBirthdayQuery() |>
  glimpse()

cdm$cohort1 |>
  addBirthdayQuery(birthday = 5) |>
  glimpse()
}

}
