% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBirthDay.R
\name{addBirthday}
\alias{addBirthday}
\title{Add the birth day of an individual to a table}
\usage{
addBirthday(
  x,
  birthday = 0,
  birthdayName = "birthday",
  ageMissingMonth = 1L,
  ageMissingDay = 1L,
  ageImposeMonth = FALSE,
  ageImposeDay = FALSE,
  name = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{birthday}{Number of birth day.}

\item{birthdayName}{Birth day variable name.}

\item{ageMissingMonth}{Month of the year assigned to individuals with missing
month of birth.}

\item{ageMissingDay}{day of the month assigned to individuals
with missing day of birth.}

\item{ageImposeMonth}{TRUE or FALSE. Whether the month of the date of birth
will be considered as missing for all the individuals.}

\item{ageImposeDay}{TRUE or FALSE. Whether the day of the date of birth
will be considered as missing for all the individuals.}

\item{name}{Name of the new table, if NULL a temporary table is returned.}
}
\value{
The table with a new column containing the birth day.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The function accounts for leap years and corrects the invalid dates to the
next valid date.
}
\examples{
\donttest{
library(PatientProfiles)
library(dplyr)

cdm <- mockPatientProfiles(source = "duckdb")

cdm$cohort1 |>
  addBirthday() |>
  glimpse()

cdm$cohort1 |>
  addBirthday(birthday = 5, birthdayName = "bithday_5th") |>
  glimpse()
}

}
