% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMisc.R
\name{pspace.pals}
\alias{pspace.pals}
\title{Create interpolated color palettes for PathwaySpace images}
\usage{
pspace.pals(
  colors = c("#303f9d", "#578edb", "#63b946", "#f3930c", "#a60d0d"),
  trim.colors = c(3, 2, 1, 2, 3),
  offset = 0.5,
  n = 25
)
}
\arguments{
\item{colors}{A vector of five base colors used to construct the custom
diverging palette. These colors are interpolated according to the
`trim.colors` values.}

\item{trim.colors}{A vector of five positive integers that control the
relative weight of each hue in the five-color diverging palette.}

\item{offset}{Adjusts brightness by shifting hues toward the center,
either brighter (`offset > 0`) or darker (` offset < 0`).}

\item{n}{The number of colors to generate in the output palette.}
}
\value{
A vector with hexadecimal color codes.
}
\description{
Creates mixed color palettes by interpolating and offsetting hues, useful for
generating transitions between hues.
}
\examples{
pspace.pals()

}
\seealso{
\code{\link{plotPathwaySpace}}
}
