% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_transition}
\alias{plot_transition}
\title{Plot the transition function of an estimated PSTR model}
\usage{
plot_transition(
  obj,
  size = 1.5,
  color = "blue",
  xlim = NULL,
  ylim = NULL,
  fill = NULL,
  alpha = NULL
)
}
\arguments{
\item{obj}{An object of class \code{"PSTR"}.}

\item{size}{Point size.}

\item{color}{Point colour.}

\item{xlim}{Optional numeric vector of length 2 specifying x-axis limits.}

\item{ylim}{Optional numeric vector of length 2 specifying y-axis limits.}

\item{fill}{Optional colour for highlighting the support of observed q.}

\item{alpha}{Transparency level for points and shading.}
}
\value{
A \code{ggplot2} object.
}
\description{
This function plots the estimated transition function
\eqn{g(q;\gamma,c)} of a fitted PSTR model.
}
\details{
Observed transition values are displayed together with the
fitted transition curve. For models with multiple switches,
multiple curves are shown.

In addition to the exported function
\code{plot_transition(obj = ...)}, the same functionality is
available as an R6 method via \code{obj$plot_transition(...)}.
}
\examples{
\donttest{
pstr <- NewPSTR(Hansen99, dep = "inva", indep = 4:20,
                indep_k = c("vala","debta","cfa","sales"),
                tvars = c("vala"), iT = 14)

pstr <- EstPSTR(use = pstr, im = 1, iq = 1,
                useDelta = TRUE, par = c(.63,0), method = "CG")

# Exported function
plot_transition(pstr)

# R6 method
pstr$plot_transition()
}

}
