% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardClickCalcs.R
\name{standardClickCalcs}
\alias{standardClickCalcs}
\title{Calculate a Set of Measurements for Clicks}
\usage{
standardClickCalcs(
  data,
  sr_hz = "auto",
  calibration = NULL,
  filterfrom_khz = 10,
  filterto_khz = NULL,
  winLen_sec = 0.0025
)
}
\arguments{
\item{data}{a list that must have 'wave' containing the wave form as a
matrix with a separate column for each channel, and 'sr' the
sample rate of the data. Data can also be a \code{Wave} class
object, like one created by \code{\link[tuneR]{Wave}}.}

\item{sr_hz}{either \code{'auto'} (default) or the numeric value of the sample
rate in hertz. If \code{'auto'}, the sample rate will be read from the
'sr' of \code{data}}

\item{calibration}{a calibration function to apply to the spectrum, must be
a gam. If NULL no calibration will be applied (not recommended).}

\item{filterfrom_khz}{frequency in khz of highpass filter to apply, or the lower
bound of a bandpass filter if \code{filterto_khz} is not \code{NULL}}

\item{filterto_khz}{if a bandpass filter is desired, set this as the upper bound.
If only a highpass filter is desired, leave as the default \code{NULL} value}

\item{winLen_sec}{length in seconds of fft window. The click wave is first
shortened to this number of samples around the peak of the wave,
removing a lot of the noise around the click. Following approach of
JB/EG/MS.}
}
\value{
A data frame with one row for each channel of click waveform
}
\description{
Calculate a set of "standard" measurements for odontocete clicks
}
\details{
Calculations of parameters mostly follow the approach outlined in Griffiths
  et al (2020) <doi:10.1121/10.0001229> and Baumann-Pickering et al (2010)
  <doi:10.1121/1.3479549>.
  Additionally, up to 3 highest peak frequencies and the "troughs" between them are
  calculated (see \link[PAMmisc]{peakTrough})
}
\examples{

data(testClick)
standardClickCalcs(testClick)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
