% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindStudies.R
\name{bindStudies}
\alias{bindStudies}
\title{Combine AcousticStudy Objects}
\usage{
bindStudies(...)
}
\arguments{
\item{\dots}{AcousticStudy objects, or a list of AcousticStudy objects}
}
\value{
A single AcousticStudy object
}
\description{
Combines multiple AcousticStudy objects (or lists of these)
  into a single object
}
\details{
All events will be combined into one large list of events. Files,
  settings, effort, models, GPS, and ancillary fields will be combined
  using the \link[PAMmisc]{squishList} function from the PAMmisc package
  (dataframes are combined, vectors are appended). The id is changed by
  pasting all IDs together along with a note that they have been combined.
  Note that the \linkS4class{PAMpalSettings} object in the pps slot is just
  left as the \code{pps} in the first AcousticStudy to be combined, and thus
  is not representative of the new combined AcousticStudy
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
