% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OGA.R
\name{OGA}
\alias{OGA}
\title{Orthogonal greedy algorithm}
\usage{
OGA(X, y, Kn = NULL, c1 = 5)
}
\arguments{
\item{X}{Input matrix of \code{n} rows and \code{p} columns.}

\item{y}{Response vector of length \code{n}.}

\item{Kn}{The number of OGA iterations. \code{Kn} must be a positive integer between \code{1} and \code{p}. Default is \code{Kn=max(1, min(floor(c1}*\code{sqrt(n/log(p))), p))}, where \code{c1} is a tuning parameter.}

\item{c1}{The tuning parameter for the number of OGA iterations. Default is \code{c1=5}.}
}
\value{
\item{n}{The number of observations.}

\item{p}{The number of input variables.}

\item{Kn}{The number of OGA iterations.}

\item{J_OGA}{The index set of \code{Kn} variables sequencially selected by OGA.}
}
\description{
Select valuables via orthogonal greedy algorithm (OGA).
}
\examples{
# Example setup (Example 3 in Section 5 of Ing and Lai (2011))
n = 400
p = 4000
q = 10
beta_1q = c(3, 3.75, 4.5, 5.25, 6, 6.75, 7.5, 8.25, 9, 9.75)
b = sqrt(3/(4 * q))

x_relevant = matrix(rnorm(n * q), n, q)
d = matrix(rnorm(n * (p - q), 0, 0.5), n, p - q)
x_relevant_sum = apply(x_relevant, 1, sum)
x_irrelevant = apply(d, 2, function(a) a + b * x_relevant_sum)
X = cbind(x_relevant, x_irrelevant)
epsilon = rnorm(n)
y = as.vector((x_relevant \%*\% beta_1q) + epsilon)

# Select valuables via OGA
OGA(X, y)
}
\references{
Ing, C.-K. and Lai, T. L. (2011). A stepwise regression method and consistent model selection for high-dimensional sparse linear models. \emph{Statistica Sinica}, \strong{21}, 1473--1513.
}
\author{
Hai-Tang Chiou, Ching-Kang Ing and Tze Leung Lai.
}
