% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofTest.R
\name{mixTest}
\alias{mixTest}
\title{Goodness of Fit Test for Finite Mixture Models}
\usage{
mixTest(x, alpha = 0.10, C.max = 10, nboot = 500, nstart = 5)
}
\arguments{
\item{x}{a vector of observations.}

\item{alpha}{significance level of the test.}

\item{C.max}{maximum number of mixture components considered in the test.
The test is performed for 2 to \code{C.max} components.}

\item{nboot}{number of bootstrap resampling. Default is 500.}

\item{nstart}{number of initializations to try. Default if 5.}
}
\value{
A list containing the following elements:
\item{GOFstats}{vector of test statistics calculated from data, in the order \code{of c(ks, cvm, kui, wat, ad)}.}
\item{ks}{vector of the Kolmogorov-Smirnov (KS) statistic for each bootstrap sample.}
\item{cvm}{vector of the Cramer-Von Mises statistic for each bootstrap sample.}
\item{kui}{vector of the Kuiper's statistic for each bootstrap sample.}
\item{wat}{vector of the Watson statistic for each bootstrap sample.}
\item{ad}{vector of the Anderson Darling statistic for each bootstrap sample.}
\item{result}{vector of test results based on the KS statistic.
If the kth element in the vector is 1, k-component mixture model is significant
based on the KS statistic; If 0, otherwise. See examples for details.}
}
\description{
`mixTest' is used to perform a goodness-of-fit test for finite mixture models (Wichitchan et al., 2019).
It returns five types of goodness-of-fit statistics and determines the number of components
in the mixture model based on the Kolmogorov-Smirnov (KS) statistic.
The test is performed using bootstrapping.
}
\examples{
n = 100
mu = c(-2.5, 0)
sd = c(0.8, 0.6)
n1 = rbinom(n, 1, 0.3)
x = c(rnorm(sum(n1), mu[1], sd[1]), rnorm(n - sum(n1), mu[2], sd[2]))

# The result shows that two-component mixture model is statistically significant based on the KS.
\donttest{out = mixTest(x, alpha = 0.10, C.max = 10, nboot = 500, nstart = 5)}
}
\references{
Wichitchan, S., Yao, W., and Yang, G. (2019). Hypothesis testing for finite mixture models.
Computational Statistics & Data Analysis, 132, 180-189.
}
