% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sim.R
\docType{data}
\name{data_sim_binary}
\alias{data_sim_binary}
\title{Example Dataset: Simulated CRT (binary outcome)}
\format{
A data frame with the following variables (10 columns):
\describe{
  \item{A}{Cluster-level treatment assignment (0/1), constant within cluster.}
  \item{H1}{Cluster-level covariate 1.}
  \item{H2}{Cluster-level covariate 2.}
  \item{N}{Cluster size recorded on each row (repeats within cluster).}
  \item{X1}{Individual-level covariate 1 (numeric).}
  \item{X2}{Individual-level covariate 2 (numeric or binary coded 0/1).}
  \item{Y}{Observed binary outcome (0/1).}
  \item{Y0}{Potential outcome under control (0/1).}
  \item{Y1}{Potential outcome under treatment (0/1).}
  \item{cluster_id}{Cluster identifier (integer or factor), constant within cluster.}
}
}
\source{
Simulated data included with the package for examples.
}
\usage{
data(data_sim_binary)
}
\description{
A simulated dataset for demonstrating \pkg{MRStdCRT} with a binary outcome.
Treatment is assigned at the cluster level and is constant within cluster.
}
\examples{
data(data_sim_binary)
head(data_sim_binary)
with(data_sim_binary, table(A, Y))
}
\keyword{datasets}
