\name{MRHawkes-package}
\alias{MRHawkes}
\docType{package}
\title{
  \packageTitle{MRHawkes}
}
\description{
  Simulate the (bivariate) multivariate renewal Hawkes (MRHawkes) process with 
  a given distribution for the two waiting times between immigrants, given
  offspring density functions, and also the branching ratios. Calculation of the
  likelihood of a MRHawkes process model with a given sequence of
  (distinct) event times and labels up to a censoring time. Calculate the
  Rosenblatt residuals of fitting an MRHawkes process model to a sequence
  of event times and labels. Calculate the (filtering) distribution of the 
  index of the most recent immigrant. Predict the time of the next event 
  since the censoring time. Predict event times from the censoring time to a
  future time point. 
}
\details{
  The DESCRIPTION file:
    \packageDESCRIPTION{MRHawkes}
  \packageIndices{MRHawkes}
}
\author{
  Tom Stindl <t.stindl@unsw.edu.au>
  Feng Chen <feng.chen@unsw.edu.au>
}
\references{
  Chen, F. and Stindl, T. (2017). Direct Likelihood Evaluation for the Renewal
  Hawkes Process. Journal of Computational and Graphical Statistics.

  Stindl, T. & Chen, F. (2018). Likelihood based inference for the multivariate 
  renewal Hawkes process. Computational Statistics and Data Analysis.
  
  Wheatley, S., Filimonov, V., and Sornette, D. (2016) The Hawkes process
  with renewal immigration & its  estimation with an EM
  algorithm. Computational Statistics and Data Analysis. 94: 120-135.
  
}
\keyword{ package }

