% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_Single_MVN.R
\name{FitMVN}
\alias{FitMVN}
\title{Fit Multivariate Normal Distribution}
\usage{
FitMVN(
  data,
  init_mean = NULL,
  fix_mean = FALSE,
  init_cov = NULL,
  lambda = 0,
  maxit = 100,
  eps = 1e-06,
  report = TRUE
)
}
\arguments{
\item{data}{Numeric data matrix.}

\item{init_mean}{Optional initial mean vector.}

\item{fix_mean}{Fix the mean to its starting value? Initial values must be
provided if \code{TRUE}.}

\item{init_cov}{Optional initial covariance matrix.}

\item{lambda}{Optional ridge term added to covariance matrix to ensure 
positive definiteness.}

\item{maxit}{Maximum number of EM iterations.}

\item{eps}{Minimum acceptable increment in the EM objective.}

\item{report}{Report fitting progress?}
}
\value{
An object of class \code{mvn}.
}
\description{
Given a matrix of n x d-dimensional random vectors, possibly containing
missing elements, estimates the mean and covariance of the best fitting
multivariate normal distribution.
}
