% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_Imputation.R
\name{CombineMIs}
\alias{CombineMIs}
\title{Combine Multiple Imputations}
\usage{
CombineMIs(points, covs)
}
\arguments{
\item{points}{List of point estimates (each may be a vector or scalar).}

\item{covs}{List of estimated sampling covariance matrices (or variances
for scalar estimates), one per imputation.}
}
\value{
List containing the combined point estimate (\code{point}) and
  the combined sampling covariance (\code{cov}).
}
\description{
Combines point estimates and their estimated sampling (co)variances across
multiple imputations using the usual multiple-imputation combining rules.
}
\examples{
set.seed(100)

# Generate data and introduce missingness.
data <- rGMM(n = 25, d = 2, k = 1)
data[1, 1] <- NA
data[2, 2] <- NA
data[3, ] <- NA 

# Fit GMM.
fit <- FitGMM(data)

# Lists to store summary statistics.
points <- list()
covs <- list()

# Perform 50 multiple imputations.
# For each, calculate the marginal mean and its sampling variance.
for (i in seq_len(50)) {
  imputed <- GenImputation(fit)
  points[[i]] <- apply(imputed, 2, mean)
  covs[[i]] <- cov(imputed) / nrow(imputed)
}

# Combine summary statistics across imputations.
results <- CombineMIs(points, covs)
}
