% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08_Clustering.R
\name{ClustQual}
\alias{ClustQual}
\title{Cluster Quality}
\usage{
ClustQual(fit)
}
\arguments{
\item{fit}{Object of class mix.}
}
\value{
List containing the cluster quality metrics.
}
\description{
Evaluates cluster quality. Returns the following metrics:
\itemize{
\item BIC: Bayesian Information Criterion; lower is better.
\item CHI: Calinski-Harabasz index; higher is better.
\item DBI: Davies-Bouldin index; lower is better.
\item SIL: Mean silhouette width; higher is better.
}
}
\examples{
set.seed(100)

# Data generation
mean_list = list(
c(2, 2, 2),
c(-2, 2, 2),
c(2, -2, 2),
c(2, 2, -2)
)

data <- rGMM(n = 500, d = 3, k = 4, means = mean_list)
fit <- FitGMM(data, k = 4)

# Clustering quality
cluster_qual <- ClustQual(fit)
}
\seealso{
See \code{\link{ChooseK}} for using quality metrics to choose the cluster number.
}
