% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportion.positive.R
\name{proportion.positive}
\alias{proportion.positive}
\title{Proportion Positive Predictions}
\usage{
proportion.positive(predictmatrix, cutoff)
}
\arguments{
\item{predictmatrix}{A matrix of predicted values from each tree (rows = observations, columns = trees).}

\item{cutoff}{Numeric value specifying the proportion of trees that must predict a class of one for the
overall prediction to be class one.}
}
\value{
A list with:
\item{predmat}{A two-column matrix where the first column is the proportion of trees predicting class one
for each observation, and the second column is the binary predicted class (0 or 1).}
}
\description{
Internal function used by \code{\link{predict.logforest}} to determine the proportion of logic regression trees
within a logic forest that predict a class of one for new observations.
It also returns the predicted class values based on a specified cutoff.
}
\details{
This function is called internally by \code{\link{predict.logforest}} and is not intended for direct use.
It calculates, for each observation, the fraction of trees in the logic forest predicting a positive outcome,
and then assigns a predicted class based on whether this fraction meets or exceeds the \code{cutoff}.
}
\note{
This is a supplementary function and not intended to be used independently of the other functions in the package.
}
\author{
Bethany Wolf \email{wolfb@musc.edu}
}
\keyword{internal}
