#' Generate All Combinations of N Variables with a Specified Conjunction Value
#'
#' Creates a matrix representing all possible combinations of \code{n.pair} variables.
#' Each row corresponds to a unique combination, and each column represents a variable
#' where 1 indicates inclusion and \code{conj} indicates exclusion.
#'
#' @param n.pair Integer. Number of predictors in the combination.
#' @param conj Numeric. Value denoting absence of a variable in a combination (default is 0).
#'
#' @return A matrix with \code{2^n.pair} rows and \code{n.pair} columns, where each row is a unique combination of 1s and \code{conj} values.
#'
#' @details
#' This is an internal function called by \code{prime.imp} and is not intended for independent use.
#'
#' @author
#' Bethany Wolf \email{wolfb@@musc.edu}
#'
#' @keywords internal
p.combos<-function(n.pair,conj=0)
{
  mat<-matrix(0,2^n.pair,n.pair)
  for(i in 1:n.pair)
  {
    mat[, i]<-rep(rep(c(1,conj),e=2^(n.pair-i)),2^(i-1))
  }
  mat
}
