% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dantzig_CrossVal.R
\name{cv_dantzig_missing}
\alias{cv_dantzig_missing}
\title{Cross-validated Dantzig estimator with missing covariates}
\usage{
cv_dantzig_missing(
  X, y, X_unlabeled = NULL,
  lambdas = NULL, nlambda = 30, lambda_min_ratio = 1e-3,
  K = 5, standardise = TRUE, gurobi = FALSE,
  seed = 123, fold_ids = NULL, verbose = TRUE,
  plot_path = TRUE
)
}
\arguments{
\item{X}{Labelled covariates.}

\item{y}{Response variables for the labelled data.}

\item{X_unlabeled}{Optional unlabeled covariates.}

\item{lambdas}{Optional sequence of regularisation parameters.}

\item{nlambda}{Number of lambdas if \code{lambdas} is not supplied.}

\item{lambda_min_ratio}{Smallest lambda as a fraction of the largest.}

\item{K}{Number of cross-validation folds.}

\item{standardise}{Logical; if TRUE covariates are standardised.}

\item{gurobi}{Logical; if TRUE uses Gurobi to solve the linear programs.}

\item{seed}{Random seed for fold assignment.}

\item{fold_ids}{Optional fold assignments for labelled or combined data.}

\item{verbose}{Logical; print progress messages.}

\item{plot_path}{Logical; if TRUE computes and plots the solution path.}
}
\value{
A named list with the following components:
\describe{
\item{lambdas}{Numeric vector of tuning parameters used.}
\item{cv_scores_matrix}{Numeric matrix of cross-validation scores (folds × lambdas).}
\item{mean_scores}{Mean CV score for each lambda.}
\item{se_scores}{Standard error of CV scores for each lambda.}
\item{lambda_min_mean}{Lambda minimising mean CV score.}
\item{lambda_1se}{Lambda chosen by the 1-SE rule.}
\item{beta_path}{Optional coefficient path matrix (present if \code{plot_path=TRUE}).}
\item{design_colnames}{Optional design column names (matching \code{beta_path} rows).}
\item{beta_est}{Optional saved coefficient vector from full-data path.}
\item{intercept_est}{Optional saved intercept corresponding to \code{beta_est}.}
}
}
\description{
Performs K-fold cross-validation for the Dantzig selector in linear regression
models with missing covariates. The method optionally incorporates unlabelled
covariate data to improve estimation of second-moment matrices. This function is based on
Section 3 of \insertCite{RisebrowSSLR;textual}{LRMiss}.
}
\details{
For each candidate value of the regularisation parameter, the Dantzig selector
is fitted using moment estimates computed from the training folds. Prediction
performance is assessed on held-out folds via the maximum absolute moment
mismatch. The tuning parameter is selected using both the minimum mean
cross-validation score and the one-standard-error (1-SE) rule.
}
\examples{
set.seed(1)
n <- 50; p <- 5
X <- matrix(rnorm(n * p), n, p)
y <- X[, 1] + 0.5 * X[, 2] + rnorm(n)
X_unlabeled <- matrix(rnorm(100 * p), 100, p)

cv_fit <- cv_dantzig_missing(
  X = X,
  y = y,
  X_unlabeled = X_unlabeled,
  K = 5,
  nlambda = 20
)

cv_fit$lambda_1se
}
\references{
\insertRef{RisebrowSSLR}{LRMiss}
}
