% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_custom_agent.R
\name{state_graph_utils}
\alias{state_graph_utils}
\alias{make_node}
\alias{make_edge}
\alias{make_command}
\alias{interrupt}
\alias{StateGraph}
\title{State Graph Utilities for Custom Agents}
\usage{
make_node(func, name = NULL)

make_edge(from, to, condition = NULL, label = NULL)

make_command(goto = NULL, update = list())

interrupt(value)

StateGraph()
}
\arguments{
\item{func}{A function that accepts a `state` list and returns either:
1) a named list of state updates, or
2) a command list created by [make_command()].}

\item{name}{Optional node name label.}

\item{from}{Source node name.}

\item{to}{Destination node name.}

\item{condition}{Optional function `function(state)` that returns a label used
for conditional routing.}

\item{label}{Optional label matched against the value returned by `condition`.}

\item{goto}{Next node name to jump to.}

\item{update}{Named list of state fields to merge before jumping.}

\item{value}{Prompt text shown to the user.}
}
\value{
A list with `func` and `name`.

A list with `from`, `to`, `condition`, and `label`.

A command-like list with `goto` and `update`.

A character string from `readline()`.

A list with methods:
  - `add_node(name, func)`
  - `add_edge(from, to)`
  - `add_conditional_edges(node_name, condition_fun, mapping_list)`
  - `set_entry_point(node_name)`
  - `compile(checkpointer = NULL)`
  - `END_NODE_NAME`
}
\description{
Lightweight graph primitives used by LLMAgentR's workflow agents.
These utilities are exported so users can build custom state-machine agents.
}
