% Generated by roxygen2: do not edit by hand
\name{cohens_d}
\alias{cohens_d}
\alias{assess_separation}
\title{Separation Quality Assessment}
\usage{
cohens_d(x, y)

assess_separation(pc_mp, nc_mp, pc_ttt, nc_ttt)
}
\arguments{
\item{x}{First distribution (numeric vector)}

\item{y}{Second distribution (numeric vector)}

\item{pc_mp}{Positive control MP values}

\item{nc_mp}{Negative control MP values}

\item{pc_ttt}{Positive control TTT values}

\item{nc_ttt}{Negative control TTT values}
}
\value{
\code{cohens_d} returns a single numeric value (positive = x > y),
or \code{NA_real_} if insufficient data.

\code{assess_separation} returns a list with:
\describe{
  \item{d_mp}{Cohen's d for MP}
  \item{d_ttt}{Cohen's d for TTT}
  \item{d_combined}{Median of absolute d values}
  \item{regime}{Separation regime: "poor_separation", "moderate_separation", or "strong_separation"}
  \item{recommended_profile}{Recommended profile: "matrix_robust", "sensitive", or "standard"}
}
}
\description{
\code{cohens_d} computes Cohen's d effect size between two distributions.

\code{assess_separation} evaluates PC/NC separation quality and recommends
a classification profile. Cohen's d thresholds are heuristic, calibrated
against three RT-QuIC datasets.
}
\examples{
set.seed(42)
pc_mp <- rnorm(8, 100, 10)
nc_mp <- rnorm(8, 20, 5)
pc_ttt <- rnorm(8, 8, 1)
nc_ttt <- rnorm(8, 72, 5)

cohens_d(pc_mp, nc_mp)
assess_separation(pc_mp, nc_mp, pc_ttt, nc_ttt)
}
