% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/albums.R
\name{getAlbumMusicinfo}
\alias{getAlbumMusicinfo}
\title{Get tag list of an album}
\usage{
getAlbumMusicinfo(
  album_id = NULL,
  album_name = NULL,
  client_id = Sys.getenv("JAMENDO_CLIENT_ID")
)
}
\arguments{
\item{album_id}{Album ID to seach for}

\item{album_name}{Album name to seach for}

\item{client_id}{Defaults to System Environment variable "JAMENDO_CLIENT_ID"}
}
\value{
Returns a data frame which contains tag list of an album.
See \url{https://developer.jamendo.com/v3.0/albums/musicinfo} for more information.
}
\description{
Get tag list of an album. You can search for either an album ID or an album name.
}
\examples{
\donttest{
##Example
 tagsFromID <- getAlbumMusicinfo(album_id = "14866")
 tagsFromName <- getAlbumMusicinfo(album_name = "Deuteranopia Utopia")
}
}
