#' Phenobarb Dataset
#'
#' This dataset contains longitudinal data on Phenobarbital concentration levels in newborn infants.
#'
#' @format A data frame with 744 observations on the following 7 variables:
#' \describe{
#'   \item{Subject}{An ordered factor identifying the infant.}
#'   \item{Wt}{A numeric vector giving the birth weight of the infant (kg).}
#'   \item{Apgar}{An ordered factor giving the 5-minute Apgar score for the infant. This is an indication of the newborn's health.}
#'   \item{ApgarInd}{A factor indicating whether the 5-minute Apgar score is < 5 or >= 5.}
#'   \item{time}{A numeric vector giving the time when the sample is drawn or the drug is administered (hr).}
#'   \item{dose}{A numeric vector giving the dose of drug administered (\eqn{\mu} g/kg).}
#'   \item{conc}{A numeric vector giving the phenobarbital concentration in the serum (\eqn{\mu} g/L).}
#' }
#' @source MEMSS R package
#' @examples
#' data(Phenobarb)
#' head(Phenobarb)
"Phenobarb"
